/*------------------------------------------------------------------------------*
 * File Name: dragNdrop.h	 													*
 * Creation: AW 09/26/06														*
 * Purpose: OriginC header file													*
 * Copyright (c) Originlab Corp. 2006, 2007, 2008								*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER							*
 * Sim 05-30-2007 PROVIDE_SOLUTION_FOR_IMPORT_FILE_FROM_80_OC					*
 *	Folger 05/05/09 QA80-4588 BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT*
 *	Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE				*
 *	Hong 09/04/09 QA80-14266 SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
 *	Folger 09/10/09 BATCH_PROCESS_SHOULD_POPUP_FILTER_SELECTION_DIALOG_AT_MOST_ONCE
 *	Folger 09/11/09 BATCH_PROCESS_SUPPORT_GET_FILTER_INFO_FROM_LAST_IMPORT		*
 *	Hong 09/22/09 QA90-13580 FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY	*
 *	Folger 11/18/09 FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
 *------------------------------------------------------------------------------*/

#ifndef _DRAG_N_DROP_H
#define _DRAG_N_DROP_H

// ---------------------------------------------------------------------------------------------------------------------------------------
/*
	Very important!!!
	
	Any functions with name __XXX mean they are Origin Internal Function. So they are not OC interface for User Custom OC Function.
	If user want to use them, please refer to FileImport.h(.c)
*/
// ---------------------------------------------------------------------------------------------------------------------------------------

//// AW 09/26/06 MORE_ON_ADD_IMPFILE_XF
/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
//BOOL ImportFiles(StringArray& stDataFileName, LPCSTR strPageName, int nIndexLayer, TreeNode& trFilter = NULL);
///------ Folger 05/05/09 QA80-4588 BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT
//BOOL ImportFiles(StringArray& stDataFileName, LPCSTR strPageName, int nIndexLayer, TreeNode& trFilter = NULL, LPCSTR lpcszTypes = NULL);
enum
{
	IMPORT_FILES_IGNORE_DRAG_AND_DROP_SUPPORT			= 0x00000001,
	/// Hong 09/04/09 QA80-14266 SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
	IMPORT_FILES_SEL_FILTER_DLG_HIDE_IMP_WIZ_BTN		= 0x00000002,
	IMPORT_FILES_SEL_FILTER_DLG_SHOW_SAVE_TO_PAGE_CHKBX	= 0x00000004,
	/// end SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
	///------ Folger 09/10/09 BATCH_PROCESS_SHOULD_POPUP_FILTER_SELECTION_DIALOG_AT_MOST_ONCE
	IMPORT_FILES_SEL_FILTER_DLG_NO_APPLY_TO_ALL			= 0x00000008,
	///------ End BATCH_PROCESS_SHOULD_POPUP_FILTER_SELECTION_DIALOG_AT_MOST_ONCE
	///------ Folger 09/11/09 BATCH_PROCESS_SUPPORT_GET_FILTER_INFO_FROM_LAST_IMPORT
	IMPORT_FILES_CHECK_USE_LAST_IMPORT_SETTINGS			= 0x00000010,
	///------ End BATCH_PROCESS_SUPPORT_GET_FILTER_INFO_FROM_LAST_IMPORT
	/// Hong 09/22/09 QA90-13580 FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
	IMPORT_FILES_DRAG_N_DROP_TO_WORKSPACE				= 0x00000020,
	/// end FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
	///------ Folger 11/18/09 FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
	IMPORT_FILES_FORCE_ASCII_FILTER_IF_NONE				= 0x00000040,
	IMPORT_FILES_NO_FILTER_APPLICABLE_CHECKING			= 0x00000080,
	///------ End FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
};
///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
//BOOL ImportFiles(StringArray& stDataFileName, LPCSTR strPageName, int nIndexLayer, TreeNode& trFilter = NULL, LPCSTR lpcszTypes = NULL, DWORD dwCntrl = 0);
///------ Folger 09/10/09 BATCH_PROCESS_SHOULD_POPUP_FILTER_SELECTION_DIALOG_AT_MOST_ONCE
//BOOL import_files_ex(const StringArray& stDataFileName, LPCSTR strPageName, int nIndexLayer, TreeNode& trFilter = NULL, LPCSTR lpcszTypes = NULL, DWORD dwCntrl = 0);
BOOL import_files_ex(const StringArray& stDataFileName, LPCSTR strPageName, int nIndexLayer, TreeNode& trFilter = NULL, LPCSTR lpcszTypes = NULL, DWORD dwCntrl = 0, TreeNode* ptrFilterLastUsed= NULL);
///------ End BATCH_PROCESS_SHOULD_POPUP_FILTER_SELECTION_DIALOG_AT_MOST_ONCE
///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
///------ End BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT
/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
// Last updated comment by Sim, 05-12-09
/**$
	nLocation = [input]
				0 = Data file folder
				1 = Origin working filter folder
				2 = User filter folder
				3 = In target Page ( don't work )
				4 = Full path
*/
///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
//BOOL LoadFilter(string& strFilterName, String& strDatFile, string& strPageName, int location, TreeNode& trFilter);
BOOL load_import_filter_ex(LPCSTR lpcszFilterName, LPCSTR lpcszDatFile, LPCSTR lpcszPageName, int nLocation, TreeNode& trFilter);
///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
/// END MORE_ON_ADD_IMPFILE_XF
/// Hong 9/28/06 MORE_ON_ADD_IMPFILE_XF
/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
//BOOL IsApplicable(TreeNode &trFilter, LPCSTR lpcszDataFile);
///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
//BOOL IsApplicable(TreeNode &trFilter, LPCSTR lpcszDataFile, LPCSTR lpcszTypes = NULL);
BOOL is_applicable_ex(TreeNode &trFilter, LPCSTR lpcszDataFile, LPCSTR lpcszTypes = NULL);
///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
/// END MORE_ON_ADD_IMPFILE_XF

///---Sim 05-30-2007 PROVIDE_SOLUTION_FOR_IMPORT_FILE_FROM_80_OC
//--------------------------------------------------------------------------
// ImportFiles
// This function is called from the OC code and is for user import file with filter manually.
//
// strPageName = target book name
// nIndexLayer = index of sheet on book
// lpcszDataFile = absolute path and name of data file
// lpcszFilterName = filter name
//
// Filter folder priority: Data Folder > Origin User Folder > Origin System Folder
//--------------------------------------------------------------------------
///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
//BOOL ImportFile(LPCSTR strPageName, int nIndexLayer, LPCSTR lpcszDataFile, LPCSTR lpcszFilterName);
BOOL import_file_ex(LPCSTR strPageName, int nIndexLayer, LPCSTR lpcszDataFile, LPCSTR lpcszFilterName = NULL);
///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
///---End PROVIDE_SOLUTION_FOR_IMPORT_FILE_FROM_80_OC

#endif // _DRAG_N_DROP_H
